#!/usr/bin/python2
# Autor: Frane Kurtovic

import string

def convert(c):
    if c in "bfpv":
        return '1'
    if c in "cgjkqsxz":
        return '2'
    if c in "dt":
        return '3'
    if c in "l":
        return '4'
    if c in "mn":
        return '5'
    if c in "r":
        return '6'
    return c

def remove_neighbours(s):
    ret = []
    for i, s_i in enumerate(s):
        if s_i not in string.digits:
            ret.append(s_i)
            continue
        if i == 0:
            ret.append(s_i)
            continue
        if ret[-1] != s_i:
            ret.append(s_i)
    return ''.join(ret)

def remove(s, char_list):
    ret = []
    for c in s:
        if c not in char_list:
            ret.append(c)
    return ''.join(ret)

def solve(s):
    s = s.lower()
    first_c = s[0]
    s_2 = s[0]+remove(s[1:], 'wh')
    # print s_2
    s_3 = ''.join(map(convert, s_2))
    # print s_3
    s_4 = remove_neighbours(s_3)
    # print s_4
    s_5 = s_4[0]+remove(s_4[1:], 'aeiouy')
    # print 's5', s_5
    if s_5[0] in string.digits:
        s_6 = first_c + s_5[1:]
    else:
        s_6 = s_5
    # print s_6
    s7 = (s_6+'0000')[:4]
    return s7[0].upper() + s7[1:]

if __name__ == "__main__":
    n = int(input())
    for _ in xrange(n):
        s = raw_input().strip()
        print solve(s)
